/**
 * Handle selection changes and actions on the competency tree.
 *
 * @module     tool_lp/competencyactions
 * @copyright  2015 Damyon Wiese <damyon@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("tool_lp/competencyactions",["jquery","core/url","core/templates","core/notification","core/str","core/ajax","tool_lp/dragdrop-reorder","tool_lp/tree","tool_lp/dialogue","tool_lp/menubar","tool_lp/competencypicker","tool_lp/competency_outcomes","tool_lp/competencyruleconfig","core/pending"],(function($,url,templates,notification,str,ajax,dragdrop,Ariatree,Dialogue,menubar,Picker,Outcomes,RuleConfig,Pending){var pageContextId,pickerInstance,ruleConfigInstance,relatedTarget,taxonomiesConstants,rulesModules,treeModel=null,moveSource=null,moveTarget=null,selectedCompetencyId=null,addHandler=function(){var parent=$('[data-region="competencyactions"]').data("competency"),params={competencyframeworkid:treeModel.getCompetencyFrameworkId(),pagecontextid:pageContextId};null!==parent&&(params.parentid=parent.id);var relocate=function(){var queryparams=$.param(params);window.location=url.relativeUrl("/admin/tool/lp/editcompetency.php?"+queryparams)};null!==parent&&treeModel.hasRule(parent.id)?str.get_strings([{key:"confirm",component:"moodle"},{key:"addingcompetencywillresetparentrule",component:"tool_lp",param:parent.shortname},{key:"yes",component:"core"},{key:"no",component:"core"}]).done((function(strings){notification.confirm(strings[0],strings[1],strings[2],strings[3],relocate)})).fail(notification.exception):relocate()},doMove=function(){var frameworkid=$('[data-region="filtercompetencies"]').data("frameworkid");ajax.call([{methodname:"core_competency_set_parent_competency",args:{competencyid:moveSource,parentid:moveTarget}},{methodname:"tool_lp_data_for_competencies_manage_page",args:{competencyframeworkid:frameworkid,search:$('[data-region="filtercompetencies"] input').val()}}])[1].done(reloadPage).fail(notification.exception)},confirmMove=function(){if((moveTarget=void 0===moveTarget?0:moveTarget)!=moveSource){var targetComp=treeModel.getCompetency(moveTarget)||{},sourceComp=treeModel.getCompetency(moveSource)||{},confirmMessage="movecompetencywillresetrules",showConfirm=!1;sourceComp.parentid!=moveTarget&&(targetComp.path&&targetComp.path.indexOf("/"+sourceComp.id+"/")>=0&&(confirmMessage="movecompetencytochildofselfwillresetrules",showConfirm=showConfirm||treeModel.hasRule(sourceComp.id)),(showConfirm=showConfirm||treeModel.hasRule(targetComp.id)||treeModel.hasRule(sourceComp.parentid))?str.get_strings([{key:"confirm",component:"moodle"},{key:confirmMessage,component:"tool_lp"},{key:"yes",component:"moodle"},{key:"no",component:"moodle"}]).done((function(strings){notification.confirm(strings[0],strings[1],strings[2],strings[3],doMove)})).fail(notification.exception):doMove())}},initMovePopup=function(popup){var body=$(popup.getContent()),treeRoot=body.find("[data-enhance=movetree]");new Ariatree(treeRoot,!1).on("selectionchanged",(function(evt,params){var target=params.selected;moveTarget=$(target).data("id")})),treeRoot.show(),body.on("click",'[data-action="move"]',(function(){popup.close(),confirmMove()})),body.on("click",'[data-action="cancel"]',(function(){popup.close()}))},addCompetencyChildren=function(parent,competencies){var i;for(i=0;i<competencies.length;i++)competencies[i].parentid==parent.id&&(parent.haschildren=!0,competencies[i].children=[],competencies[i].haschildren=!1,parent.children[parent.children.length]=competencies[i],addCompetencyChildren(competencies[i],competencies))},moveHandler=function(e){e.preventDefault();var competency=$('[data-region="competencyactions"]').data("competency");moveSource=competency.id;var requests=ajax.call([{methodname:"core_competency_search_competencies",args:{competencyframeworkid:competency.competencyframeworkid,searchtext:""}},{methodname:"core_competency_read_competency_framework",args:{id:competency.competencyframeworkid}}]);$.when.apply(null,requests).done((function(competencies,framework){var i,competenciestree=[];for(i=0;i<competencies.length;i++){var onecompetency=competencies[i];"0"==onecompetency.parentid&&(onecompetency.children=[],onecompetency.haschildren=0,competenciestree[competenciestree.length]=onecompetency,addCompetencyChildren(onecompetency,competencies))}str.get_strings([{key:"movecompetency",component:"tool_lp",param:competency.shortname},{key:"move",component:"tool_lp"},{key:"cancel",component:"moodle"}]).done((function(strings){var context={framework:framework,competencies:competenciestree};templates.render("tool_lp/competencies_move_tree",context).done((function(tree){new Dialogue(strings[0],tree,initMovePopup)})).fail(notification.exception)})).fail(notification.exception)})).fail(notification.exception)},editHandler=function(){var competency=$('[data-region="competencyactions"]').data("competency"),params={competencyframeworkid:treeModel.getCompetencyFrameworkId(),id:competency.id,parentid:competency.parentid,pagecontextid:pageContextId},queryparams=$.param(params);window.location=url.relativeUrl("/admin/tool/lp/editcompetency.php?"+queryparams)},reloadPage=function(context){templates.render("tool_lp/manage_competencies_page",context).done((function(newhtml,newjs){$('[data-region="managecompetencies"]').replaceWith(newhtml),templates.runTemplateJS(newjs)})).fail(notification.exception)},updateSearchHandler=function(e){e.preventDefault();var frameworkid=$('[data-region="filtercompetencies"]').data("frameworkid");ajax.call([{methodname:"tool_lp_data_for_competencies_manage_page",args:{competencyframeworkid:frameworkid,search:$('[data-region="filtercompetencies"] input').val()}}])[0].done(reloadPage).fail(notification.exception)},moveUpHandler=function(){var competency=$('[data-region="competencyactions"]').data("competency");ajax.call([{methodname:"core_competency_move_up_competency",args:{id:competency.id}},{methodname:"tool_lp_data_for_competencies_manage_page",args:{competencyframeworkid:competency.competencyframeworkid,search:$('[data-region="filtercompetencies"] input').val()}}])[1].done(reloadPage).fail(notification.exception)},moveDownHandler=function(){var competency=$('[data-region="competencyactions"]').data("competency");ajax.call([{methodname:"core_competency_move_down_competency",args:{id:competency.id}},{methodname:"tool_lp_data_for_competencies_manage_page",args:{competencyframeworkid:competency.competencyframeworkid,search:$('[data-region="filtercompetencies"] input').val()}}])[1].done(reloadPage).fail(notification.exception)},seeCoursesHandler=function(){var competency=$('[data-region="competencyactions"]').data("competency");ajax.call([{methodname:"tool_lp_list_courses_using_competency",args:{id:competency.id}}])[0].done((function(courses){var context={courses:courses};templates.render("tool_lp/linked_courses_summary",context).done((function(html){str.get_string("linkedcourses","tool_lp").done((function(linkedcourses){new Dialogue(linkedcourses,html,initMovePopup)})).fail(notification.exception)})).fail(notification.exception)})).fail(notification.exception)},relateCompetenciesHandler=function(){relatedTarget=$('[data-region="competencyactions"]').data("competency"),pickerInstance||(pickerInstance=new Picker(pageContextId,relatedTarget.competencyframeworkid)).on("save",(function(e,data){var pendingPromise=new Pending,compIds=data.competencyIds,calls=[];$.each(compIds,(function(index,value){calls.push({methodname:"core_competency_add_related_competency",args:{competencyid:value,relatedcompetencyid:relatedTarget.id}})})),calls.push({methodname:"tool_lp_data_for_related_competencies_section",args:{competencyid:relatedTarget.id}}),ajax.call(calls)[calls.length-1].then((function(context){return templates.render("tool_lp/related_competencies",context)})).then((function(html,js){$('[data-region="relatedcompetencies"]').replaceWith(html),templates.runTemplateJS(js),updatedRelatedCompetencies()})).then(pendingPromise.resolve).catch(notification.exception)})),pickerInstance.setDisallowedCompetencyIDs([relatedTarget.id]),pickerInstance.display()},ruleConfigHandler=function(e){e.preventDefault(),relatedTarget=$('[data-region="competencyactions"]').data("competency"),ruleConfigInstance.setTargetCompetencyId(relatedTarget.id),ruleConfigInstance.display()},ruleConfigSaveHandler=function(e,config){var update={id:relatedTarget.id,shortname:relatedTarget.shortname,idnumber:relatedTarget.idnumber,description:relatedTarget.description,descriptionformat:relatedTarget.descriptionformat,ruletype:config.ruletype,ruleoutcome:config.ruleoutcome,ruleconfig:config.ruleconfig};ajax.call([{methodname:"core_competency_update_competency",args:{competency:update}}])[0].then((function(result){result&&(relatedTarget.ruletype=config.ruletype,relatedTarget.ruleoutcome=config.ruleoutcome,relatedTarget.ruleconfig=config.ruleconfig,renderCompetencySummary(relatedTarget))})).catch(notification.exception)},doDelete=function(){var competency=$('[data-region="competencyactions"]').data("competency"),requests=ajax.call([{methodname:"core_competency_delete_competency",args:{id:competency.id}},{methodname:"tool_lp_data_for_competencies_manage_page",args:{competencyframeworkid:competency.competencyframeworkid,search:$('[data-region="filtercompetencies"] input').val()}}]);requests[0].done((function(success){!1===success&&str.get_strings([{key:"competencycannotbedeleted",component:"tool_lp",param:competency.shortname},{key:"cancel",component:"moodle"}]).done((function(strings){notification.alert(null,strings[0])})).fail(notification.exception)})).fail(notification.exception),requests[1].done(reloadPage).fail(notification.exception)},deleteCompetencyHandler=function(){var competency=$('[data-region="competencyactions"]').data("competency"),confirmMessage="deletecompetency";treeModel.hasRule(competency.parentid)&&(confirmMessage="deletecompetencyparenthasrule"),str.get_strings([{key:"confirm",component:"moodle"},{key:confirmMessage,component:"tool_lp",param:competency.shortname},{key:"delete",component:"moodle"},{key:"cancel",component:"moodle"}]).done((function(strings){notification.confirm(strings[0],strings[1],strings[2],strings[3],doDelete)})).fail(notification.exception)},dragStart=function(e){e.originalEvent.dataTransfer.setData("text",$(e.target).parent().data("id"))},allowDrop=function(e){e.originalEvent.dataTransfer.dropEffect="move",e.preventDefault()},dragEnter=function(e){e.preventDefault(),$(this).addClass("currentdragtarget")},dragLeave=function(e){e.preventDefault(),$(this).removeClass("currentdragtarget")},dropOver=function(e){e.preventDefault(),moveSource=e.originalEvent.dataTransfer.getData("text"),moveTarget=$(e.target).parent().data("id"),$(this).removeClass("currentdragtarget"),confirmMove()},deleteRelatedHandler=function(e){e.preventDefault();var relatedid=this.id.substr(11),competency=$('[data-region="competencyactions"]').data("competency");ajax.call([{methodname:"core_competency_remove_related_competency",args:{relatedcompetencyid:relatedid,competencyid:competency.id}},{methodname:"tool_lp_data_for_related_competencies_section",args:{competencyid:competency.id}}])[1].done((function(context){templates.render("tool_lp/related_competencies",context).done((function(html){$('[data-region="relatedcompetencies"]').replaceWith(html),updatedRelatedCompetencies()})).fail(notification.exception)})).fail(notification.exception)},updatedRelatedCompetencies=function(){$('[data-action="deleterelation"]').on("click",deleteRelatedHandler)},getTaxonomyAtLevel=function(level){var constant=taxonomiesConstants[level];return constant||(constant="competency"),constant},renderCompetencySummary=function(competency){var promise=$.Deferred().resolve().promise(),context={};context.competency=competency,context.showdeleterelatedaction=!0,context.showrelatedcompetencies=!0,context.showrule=!1,context.pluginbaseurl=url.relativeUrl("/admin/tool/lp"),competency.ruleoutcome!=Outcomes.NONE&&(promise=Outcomes.getString(competency.ruleoutcome).then((function(str){var name;return $.each(rulesModules,(function(index,modInfo){modInfo.type==competency.ruletype&&(name=modInfo.name)})),[str,name]}))),promise.then((function(strs){return void 0!==strs&&(context.showrule=!0,context.rule={outcome:strs[0],type:strs[1]}),context})).then((function(context){return templates.render("tool_lp/competency_summary",context)})).then((function(html){return $('[data-region="competencyinfo"]').html(html),$('[data-action="deleterelation"]').on("click",deleteRelatedHandler),templates.render("tool_lp/loading",{})})).then((function(html,js){return templates.replaceNodeContents('[data-region="relatedcompetencies"]',html,js),ajax.call([{methodname:"tool_lp_data_for_related_competencies_section",args:{competencyid:competency.id}}])[0]})).then((function(context){return templates.render("tool_lp/related_competencies",context)})).then((function(html,js){$('[data-region="relatedcompetencies"]').replaceWith(html),templates.runTemplateJS(js),updatedRelatedCompetencies()})).catch(notification.exception)},selectionChanged=function(evt,params){var node=params.selected,id=$(node).data("id"),btn=$('[data-region="competencyactions"] [data-action="add"]'),actionMenu=$('[data-region="competencyactionsmenu"]'),selectedTitle=$('[data-region="selected-competency"]'),level=0,sublevel=1;if(menubar.closeAll(),void 0===id)$('[data-region="competencyinfo"]').html(node.clone().children().remove().end().text()),$('[data-region="competencyactions"]').data("competency",null),actionMenu.hide();else{var competency=treeModel.getCompetency(id);sublevel=(level=treeModel.getCompetencyLevel(id))+1,actionMenu.show(),$('[data-region="competencyactions"]').data("competency",competency),renderCompetencySummary(competency),function(competency){competency.id!==selectedCompetencyId&&(selectedCompetencyId=competency.id,ajax.call([{methodname:"core_competency_competency_viewed",args:{id:competency.id}}]))}(competency)}return function(level){return str.get_string("taxonomy_selected_"+getTaxonomyAtLevel(level),"tool_lp")}(level).then((function(str){selectedTitle.text(str)})).catch(notification.exception),function(level){return str.get_string("taxonomy_add_"+getTaxonomyAtLevel(level),"tool_lp")}(sublevel).then((function(str){btn.show().find('[data-region="term"]').text(str)})).catch(notification.exception),evt.preventDefault(),!1};return{init:function(model,pagectxid,taxonomies,rulesMods){var all;treeModel=model,pageContextId=pagectxid,(all=taxonomies.split(",")).unshift(""),delete all[0],taxonomiesConstants=all,rulesModules=rulesMods,$('[data-region="competencyactions"] [data-action="add"]').on("click",addHandler),menubar.enhance(".competencyactionsmenu",{'[data-action="edit"]':editHandler,'[data-action="delete"]':deleteCompetencyHandler,'[data-action="move"]':moveHandler,'[data-action="moveup"]':moveUpHandler,'[data-action="movedown"]':moveDownHandler,'[data-action="linkedcourses"]':seeCoursesHandler,'[data-action="relatedcompetencies"]':relateCompetenciesHandler.bind(this),'[data-action="competencyrules"]':ruleConfigHandler.bind(this)}),$('[data-region="competencyactionsmenu"]').hide(),$('[data-region="competencyactions"] [data-action="add"]').hide(),$('[data-region="filtercompetencies"]').on("submit",updateSearchHandler),$('[data-region="managecompetencies"] [data-enhance="tree"]').on("dragstart","li>span",dragStart).on("dragover","li>span",allowDrop).on("dragenter","li>span",dragEnter).on("dragleave","li>span",dragLeave).on("drop","li>span",dropOver),model.on("selectionchanged",selectionChanged),(ruleConfigInstance=new RuleConfig(treeModel,rulesModules)).on("save",ruleConfigSaveHandler.bind(this))}}}));

//# sourceMappingURL=competencyactions.min.js.map